% THIS LINE USES PARAMETERS RESULTS FROM NOSCO FOR THE PLOTS
params = res.estimations(:,1:3);

% Window enlarge factor
wef = 5;
addpath('SH3Data')
% Copy experimental data
[ExpData,~] = Sampling();

sample = ExpData{1};
SF = ExpData{2};
sz1 = ExpData{3}(1);
sz2 = ExpData{3}(2);
zff1 = ExpData{4}(1);
zff2 = ExpData{4}(2);
SF1 = ExpData{5}(1);
SF2 = ExpData{5}(2);
winloc = ExpData{9};

% Copy NUS data
NUS_signal = res.signal;
R_scheme = res.Rscheme;
G_scheme = res.Gscheme;
spectra = res.spectra;

t1 = (0:sz1*zff1-1)./SF1;
t2 = (0:sz2*zff2-1)./SF2;

frames = 20;

for j = 1:size(winloc,1)
    winloc(j,1) = winloc(j,1)-wef;
    winloc(j,2) = winloc(j,2)+wef;
    winloc(j,3) = winloc(j,3)-wef;
    winloc(j,4) = winloc(j,4)+wef;
    Mpeak = spectra(winloc(j,1):winloc(j,2),winloc(j,3):winloc(j,4),1);
    M = max(Mpeak(:));
    v = [0.8 0.6 0.4 0.2]*M;

    for i = 1:frames
        P = G_scheme.*(1+R_scheme)+(i/frames)*params(j,3);
        Chi = (P-sqrt(P.^2-R_scheme.*(2*G_scheme).^2))./(2*G_scheme);
        arg_t1 = repmat(Chi.*t1',[1 2*sz2*zff2]);
        arg_t2 = repmat(Chi*t2,[2 1]);

        corr1 = NUS_signal.*exp(-1i*2*pi*(arg_t1*(i/frames)*params(j,1)));
        data = [real(corr1);imag(corr1)];
        fidmocplx0 = data(:,1:2:end)+1i*data(:,2:2:end);
        corr2 = fidmocplx0.*exp(-1i*2*pi*arg_t2*(i/frames)*params(j,2));
        fidmo = real(fftshift(fft(corr2,sz2*zff2,2),2));
        fidmocplx = fidmo(1:end/2,:)+1i*fidmo(end/2+1:end,:);
        spectrum = real(fftshift(fft(fidmocplx,sz1*zff1,1),1));
        peak = spectrum(winloc(j,1):winloc(j,2),winloc(j,3):winloc(j,4));
        peak_max = max(peak(:));

        subplot(2,4,1),surf(Mpeak),zlim([-0.1 1].*M),view(0,0),title('Mother')
        subplot(2,4,2),surf(Mpeak),zlim([-0.1 1].*M),view(90,0),title('Mother')
        subplot(2,4,5),surf(peak),zlim([-0.1 1].*M),view(0,0),title('Corrected')
        subplot(2,4,6),surf(peak),zlim([-0.1 1].*M),view(90,0),title('Corrected')
        subplot(2,4,[3 4 7 8]),contour(peak,v,'g','LineWidth',2),title(['Peak ',int2str(j)]),hold on
        subplot(2,4,[3 4 7 8]),contour(spectra(winloc(j,1):winloc(j,2),winloc(j,3):winloc(j,4),1),v,'k','LineWidth',2)
        subplot(2,4,[3 4 7 8]),contour(spectra(winloc(j,1):winloc(j,2),winloc(j,3):winloc(j,4),2),v,'r','LineWidth',2)
        pause(0.01)
        clf
    end
end