% Scipt to produce stratified NUS schedules
% Output files are names "schedule_x.txt" where x is schedule number

sz1 = 130;  % Size of grid in t1 dimension
N = 8;      % Number of signals (titration points)

pts = floor(sz1/N);
lop = rem(sz1,N);
y = reshape(1:sz1-lop,[N pts]);
NUS_schedule = zeros(size(y));
for i = 1:pts
    NUS_schedule(:,i) = y(randperm(N),i);
end
ylop = sz1-lop+1:sz1;
v = [ylop(randperm(lop)) NaN(1,N-lop)]';
NUS_schedule(:,end+1) = v;
NUS_schedule = NUS_schedule-1;

for i = 1:size(NUS_schedule,1)
    name = ['schedule_',int2str(i),'.txt'];
    file = fopen(name,'w');
    aux = NUS_schedule(i,~isnan(NUS_schedule(i,:)));
    for j = 1:numel(aux)
        fprintf(file,'%d\n',aux(j));
    end
    fclose(file);
end
