function [NormResiduum, Result,Pnormlist]=TailoredNorm(Decay, K, D_grid,options)
%Input:
%Decay=the vector of the Diffusion Decay from the PGSE experiment
%K  vector of k in eq I=exp(-D*k) 
%D_grid - diffusion scale vector
%options.tau - proportion between first and second term
%options.epsilon - regularization of weight to avoid diving by zero
%options.no_of_iterations=number of iterations
%Output:
%NormResiduum - The signal reconstruction residuum for different p.
%Result - the matrix of the reconstruction for different p.
%List of p
if isfield(options,'no_of_iterations')
    no_of_iterations = options.no_of_iterations;
else
    no_of_iterations = 1e2;
end
if isfield(options,'tau')
    tau = options.tau;
else
    tau = 2e-6;
end
if isfield(options,'epsilon')
    epsilon = options.epsilon;
else
    epsilon = 1e-2;
end


   for i=1:21
         Pnorm=1.00+((i-1)/20);
         Pnormlist(i)=Pnorm;
         matrix=ILTmatrix(D_grid,K);
         A=IRLS(no_of_iterations,Decay',matrix,tau,Pnorm,epsilon);
         PsiA=matrix*A;
         NormResiduum(i)=norm(PsiA-Decay');

         Result(:,i)=A';
   end
end   


function [A]=IRLS(no_of_iterations,Decay,matrix,tau,Pnorm,epsilon);
    ILT=ctranspose(matrix);
    fn=size(matrix,2);
    A=ILT*Decay;
    L=eye(size(matrix,1));
    k=0;
    while (k<no_of_iterations)
        if(Pnorm==0)
            tau=(k+1)/Niter;
            W=(1./tau)*diag(abs(A).^(1.+tau*1.)+eps^(1.+tau*1.)); 
        elseif(Pnorm==1)
            W=(1./tau)*diag(abs(A)+eps); 
        else
            W=(1./tau)*diag(abs(A+eps).^(2.-Pnorm));  
        end
        G2=matrix*W;
        B=G2*ILT+L;
        A=G2'*pinv(B,2e8)*Decay;
        A(A<0)=0;
        k=k+1;
    end
end
function [matrix]=ILTmatrix(D,K)
    for i=1:max(size(D))
        u=0;
        for j=1:max(size(K))
            u=u+1;
            matrix(j,i)=exp(-(D(i))*K(u));
        end
    end
end  
