function ReconstructedSpectrum = ITAMED3D(FID, schedule, SW, IndirectSize, DiffusionGrid, Iterations, Lambda)
% This is the main function for reconstruction of data from sparse joined
% Sampled FT-ILT experiment e.g. HSQCiDOSY with Non-uniformly sampled
% indirect dimension and diffusion dimension
%Variables:
%FID - complex matrix 1st dimension if FT of directly detected dimension
%2nd dimension is joined sampled FT-ILT dimension
%schedule - sampling schedule 1st column is increment in indirect dimension
%2n column is b-value from diffusion dim. Like in eq. I=exp(-D*b);
%SW= spectral width of indirect dimension
%IndirectSize - size of reconstruction of indirect dimension
%Diffusion Grid the grid on which you want to reconstruct diffusion
%dimension
%Iterations - number of iterations. Suggested 1e4;
% Lambda - regularization parameter. Sugested value: 100;

if (size(DiffusionGrid,2)> IndirectSize/2)
    disp('Diffusion Grid should be smaller than Indirect dimension size')
   return; 
end
gradients=schedule(:,2);
[matrix]=sparse_matrix(gradients, schedule, DiffusionGrid,SW, IndirectSize);
[ReconstructedSpectrum]=ProcessFID(FID, matrix,size(DiffusionGrid,2),IndirectSize, Lambda,Iterations);
 end  
