function [A_final,D_scale]=ITAMeD(iter,diffusion_range,I,b, lambda)
%Inputs:
%iter maximum number of iterations
%diffusion_range vector of 3 parameters [Minimal Diffusion,Maximum diffusion, number of points]
%I PFG signal (exponential decay)
%b vector of b in eq I=exp(-D*b)
%lambda Lagrangian multiplier
%Outputs:
%A_final ITAMeD result: distribution of diffusion coefficients.
%D_scale diffusion scale vector

D_scale = logspace(log10(diffusion_range(1)), log10(diffusion_range(2)), diffusion_range(3));
%Defining the Diffusion grid
testsize = size(I);
if testsize(1) ~= 1 data.II = I'; else data.II = I; end
testsize = size(b);
if testsize(1) ~= 1 data.KK = b'; else data.KK = b; end
data.NmrData.arraydim = size(data.II,2);
matAl = generate_matrix(D_scale, data);
%creating \Psi matrix of ILT
A = zeros(size(D_scale));
%initial value of vector A
[A_final] = fista(A, data.II', lambda, matAl, iter);
%Running the fista procedure
sprintf('End of calculations')
end
